///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _TABWPINDEX_H
#define _TABWPINDEX_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabWPIndexDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND hSQLServer;
    static HWND hSQLDriver;
    static HWND hSQLDatabase;
    static HWND hSQLUserName;
    static HWND hSQLPassword;

    if(uMsg == WM_INITDIALOG)
    {
        hSQLServer   = GetDlgItem(hWnd, IDC_SQLSERVER);
        hSQLDriver   = GetDlgItem(hWnd, IDC_SQLDRIVER);
        hSQLDatabase = GetDlgItem(hWnd, IDC_SQLDATABASE);
        hSQLUserName = GetDlgItem(hWnd, IDC_SQLUSERNAME);
        hSQLPassword = GetDlgItem(hWnd, IDC_SQLPASSWORD);

		Set_Text(hSQLServer, gsSQLIndexServer);
        Set_Text(hSQLDriver, gsSQLIndexDriver);
        Set_Text(hSQLDatabase, gsSQLIndexDatabase);
        Set_Text(hSQLUserName, gsSQLIndexUserID);
        Set_Text(hSQLPassword, gsSQLIndexPassword);

        return TRUE;
    }

    if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
			char sSQLIndexServer[sizeof(gsSQLIndexServer)];
			char sSQLIndexDriver[sizeof(gsSQLIndexDriver)];
			char sSQLIndexDatabase[sizeof(gsSQLIndexDatabase)];
			char sSQLIndexUserID[sizeof(gsSQLIndexUserID)];
			char sSQLIndexPassword[sizeof(gsSQLIndexPassword)];

			Get_TextEx(hSQLServer, sSQLIndexServer, sizeof(sSQLIndexServer));
			Get_TextEx(hSQLDriver, sSQLIndexDriver, sizeof(sSQLIndexDriver));
			Get_TextEx(hSQLDatabase, sSQLIndexDatabase, sizeof(sSQLIndexDatabase));
			Get_TextEx(hSQLUserName, sSQLIndexUserID, sizeof(sSQLIndexUserID));
			Get_TextEx(hSQLPassword, sSQLIndexPassword, sizeof(sSQLIndexPassword));

			strcpy_s(gsSQLIndexServer, sizeof(gsSQLIndexServer), sSQLIndexServer);
			strcpy_s(gsSQLIndexDriver, sizeof(gsSQLIndexDriver), sSQLIndexDriver);
			strcpy_s(gsSQLIndexDatabase, sizeof(gsSQLIndexDatabase), sSQLIndexDatabase);
			strcpy_s(gsSQLIndexUserID, sizeof(gsSQLIndexUserID), sSQLIndexUserID);
			strcpy_s(gsSQLIndexPassword, sizeof(gsSQLIndexPassword), sSQLIndexPassword);

			return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
